path "D:\\BIN\\GSTUDIO6\\template";	// Path to WDL templates subdirectory

include <movement.wdl>;

var video_mode = 7;	 // screen size 640x480
var video_depth = 32; // 16 bit colour D3D mode
string level_str = <rotring.WMB>; // give file names in angular brackets
var speed=2;

function main()
{
// set some common flags and variables
//	warn_level = 2;	// announce bad texture sizes and bad wdl code
	tex_share = on;	// map entities share their textures

// now load the level
	level_load(level_str);
	//camera.fog_start=800;
	//camera.fog_end=1500;
	//fog_color=1;
}

function make_look_good()
{
	me.shadow=on;
	me.transparent=on;
	me.alpha=45;
	me.metal=on;
	me.albedo=60;
}

action lights()
{
	me.invisible=on;
	me.lightrange=600;
	me.red=200;
	me.green=200;
	me.skill1=1;
	while(1)
	{
		if(me.lightrange>1000)
		{
			me.skill1=-1;
			sleep(5);
		}
		else
		{
			if(me.lightrange<600)
			{
				me.skill1=1;
				sleep(5);
			}
		}
		me.lightrange+=time*me.skill1*2;
		//camera.fog_start+=time*me.skill1*5;
		wait(1);
	}
}

action rotate_1()
{
	make_look_good();
	while(1)
	{
		me.roll+=speed*time;
		me.pan+=(speed+.2)*time;
		wait(1);
	}
}

action rotate_2()
{
	make_look_good();
	while(1)
	{
		me.roll+=(speed+.2)*time;
		me.tilt+=speed*time;
		wait(1);
	}
}

action rotate_3()
{
	make_look_good();
	while(1)
	{
		me.pan+=speed*time;
		me.tilt+=(speed+.2)*time;
		wait(1);
	}
}